//
// (c) wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.data.Core 1.0

DocumentModel {

    readonly property bool isModifyable : true

    property Document document
    property string   property

    documents : document ? (document[property] || []) : [];

    function indexOfElement(doc) {
        console.warning("deprecated function indexOfElement() - " +
                        "use indexOf() instead");
        return indexOf(doc);
    }

    function indexOf(doc) {
        if (!document)
            return -1;

        return document.indexOfListElement(property, doc);
    }

    function moveElement(from, to) {
        if (!document)
            return false;

        return document.moveListElement(property, from, to);
    }

    function insertElement(doc, index) {
        if (!document)
            return false;

        return document.insertListElement(property, doc, index);
    }

    function addElement(doc) {
        if (!document)
            return false;

        return document.addListElement(property, doc);
    }

    function removeElement(doc) {
        if (!document)
            return false;

        return document.removeListElement(property, doc);
    }

}
